"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const apg_lib_1 = require("apg-lib");
function attributePath(state, chars, phraseIndex, phraseLength, yard) {
    switch (state) {
        case apg_lib_1.ids.SEM_PRE:
            yard.pre("attributePath");
            break;
        case apg_lib_1.ids.SEM_POST:
            const { attributePathSegment } = yard.post("attributePath");
            if (attributePathSegment.length < 1) {
                throw new Error(`INVARIANT: Expected 1 or more attributePathSegment, but got ${attributePathSegment.length};`);
            }
            yard.tracks.attributePath.push(attributePathSegment.reverse());
            break;
    }
    return apg_lib_1.ids.SEM_OK;
}
exports.attributePath = attributePath;
//# sourceMappingURL=attributePath.js.map