export = Retry;
declare class Retry {
    constructor(options: RetryOptions);
    protected options: {
        setup?: (() => void | Promise<void>) | undefined;
        try: () => Promise<any>;
        success: (arg0: any) => any;
        end: (arg0: any) => any;
        retryLimit?: number | undefined;
        name: string;
        retryMin: number;
        retryBase: number;
        retryExponent: number;
        retryDelay: RetryDelayCallback;
    };
    protected log: (message: string) => void;
    protected failures: number;
    protected retrying: NodeJS.Timeout | undefined;
    protected abort: ((err: Error) => void) | undefined;
    protected promisedResult: Promise<any> | undefined;
    protected _maybeRetry(err: unknown): Promise<any>;
    protected _throttledAttempt(): Promise<any>;
    protected _try(): Promise<any>;
    protected _createTryPromise(): Promise<any>;
    try(createNew?: boolean | undefined): Promise<any>;
    end(): Promise<any>;
    stopped: boolean | undefined;
    reset(): void;
}
declare namespace Retry {
    export { RetryDelayCallback, RetryOptions };
}
type RetryDelayCallback = (failures: number) => number | false;
type RetryOptions = {
    name?: string | undefined;
    setup?: (() => void | Promise<void>) | undefined;
    try: () => Promise<any>;
    success: (arg0: any) => any;
    end: (arg0: any) => any;
    retryMin?: number | undefined;
    retryBase?: number | undefined;
    retryExponent?: number | undefined;
    retryLimit?: number | undefined;
    retryDelay?: RetryDelayCallback | undefined;
    log?: ((message: string) => void) | undefined;
};
//# sourceMappingURL=index.d.ts.map