import { Cells } from './cell/cells.class';
import { ConfigValue } from './config/config-value.type';
import { IncomingConfigValue } from './config/incoming-config-value.type';
import { PreferencesValue } from './config/preferences-value.type';
import { Preferences } from './config/preferences.class';
import { RenderConfig } from './config/render-config.type';
/**
 * Table Config API
 */
export declare class TableConfig {
    protected static readonly _preferences: Preferences;
    protected readonly _cells: Cells;
    /**
     * Create TableConfig instance
     */
    constructor();
    /**
     * Get cell config
     * @param x 0-based coordinate index (-1 for row header)
     * @param y 0 based coordinate index (-1 for column header)
     * @returns cell config
     */
    getCellConfig(x: number, y: number): ConfigValue;
    /**
     * Get meshed (cell > column > row > table) configuration for cell
     * @param x 0-based coordinate index (-1 for row header)
     * @param y 0 based coordinate index (-1 for column header)
     * @returns cell render config
     */
    getCellRenderConfig(x: number, y: number): RenderConfig;
    /**
     * Get column config
     * @param x 0-based coordinate index (-1 for row header)
     * @returns column config
     */
    getColumnConfig(x: number): ConfigValue;
    /**
     * Get generic table preferences
     * @returns preferences object
     */
    getPreferences(): PreferencesValue;
    /**
     * Get row config
     * @param y 0 based coordinate index (-1 for column header)
     * @returns row config
     */
    getRowConfig(y: number): ConfigValue;
    /**
     * Get table config
     * @returns table config
     */
    getTableConfig(): ConfigValue;
    /**
     * Update cell config
     * @param x 0-based coordinate index (-1 for row header) or pattern like: '0..2,5' (from..to, to included)
     * @param y 0 based coordinate index (-1 for column header) or pattern like: '0..2,5' (from..to, to included)
     * @param config updates
     * @returns this Table
     */
    setCellConfig(x: number | string, y: number | string, config: IncomingConfigValue): this;
    /**
     * Update column config
     * @param x 0-based coordinate index (-1 for row header) or pattern like: '0..2,5' (from..to, to included)
     * @param config updates
     * @returns this Table
     */
    setColumnConfig(x: number | string, config: IncomingConfigValue): this;
    /**
     * Update generic table preferences
     * @param preferences updates
     * @returns this Table
     */
    setPreferences(preferences: Partial<PreferencesValue>): this;
    /**
     * Update row config
     * @param y 0 based coordinate index (-1 for column header) or pattern like: '0..2,5' (from..to, to included)
     * @param config updates
     * @returns this Table
     */
    setRowConfig(y: number | string, config: IncomingConfigValue): this;
    /**
     * Update table config
     * @param config updates
     * @returns this Table
     */
    setTableConfig(config: IncomingConfigValue): this;
}
