"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.Container2D = void 0;
var Container2D = /** @class */ (function () {
    function Container2D(DataClass, defaultValueFn) {
        this.DataClass = DataClass;
        this.defaultValueFn = defaultValueFn;
        this._list = [];
    }
    Container2D.checkCoordinate = function (coord) {
        if (!Number.isInteger(coord) || coord < -1) {
            throw new Error("Table coordinate must be integer and >= -1. Received: ".concat(coord, ")"));
        }
    };
    Container2D.checkCoordinates = function (x, y) {
        Container2D.checkCoordinate(x);
        Container2D.checkCoordinate(y);
    };
    Container2D.prototype.clear = function () {
        this._list.length = 0;
    };
    Container2D.prototype.count = function (matchFn) {
        return this.filter(matchFn).length;
    };
    Container2D.prototype.filter = function (matchFn) {
        return this._list.filter(matchFn);
    };
    Container2D.prototype.flip = function () {
        this._list.forEach(function (item) {
            var _a;
            _a = [item.y, item.x], item.x = _a[0], item.y = _a[1];
        });
        this.sort();
    };
    Container2D.prototype.getsert = function (x, y) {
        Container2D.checkCoordinates(x, y);
        var item = this._list.find(function (item) { return item.x === x && item.y === y; });
        if (!item) {
            this._list.push(item = new this.DataClass(this, x, y, this.defaultValueFn()));
            this.sort();
        }
        return item;
    };
    Container2D.prototype.indices = function (matchFn) {
        var indices = [];
        for (var i = this._list.length - 1; i >= 0; i--) {
            if (matchFn(this._list[i])) {
                indices.push(i);
            }
        }
        return indices.sort(function (a, b) { return a > b ? -1 : 1; });
    };
    Container2D.prototype.max = function (numberValFn, min) {
        if (min === void 0) { min = 0; }
        var max = min;
        var maxFn = function (item) {
            var n = numberValFn(item);
            if (n > max) {
                max = n;
            }
        };
        this._list.forEach(maxFn);
        return max;
    };
    Container2D.prototype.remove = function (matchFn) {
        var _this = this;
        this.indices(matchFn).forEach(function (index) { return _this._list.splice(index, 1); });
    };
    Container2D.prototype.splice = function (vertical, i, remove, insert) {
        if (insert === void 0) { insert = 0; }
        Container2D.checkCoordinate(i);
        remove = remove > 0 ? Math.floor(remove) : 0;
        insert = insert > 0 ? Math.floor(insert) : 0;
        var axis = vertical ? 'x' : 'y';
        this.remove(function (cell) { return cell[axis] >= i && cell[axis] < i + remove; });
        var diff = insert - remove + (i === -1 ? 1 : 0);
        this.filter(function (cell) { return cell[axis] >= i; }).forEach(function (cell) { return cell[axis] += diff; });
    };
    Container2D.prototype.upsert = function (x, y, value) {
        this.getsert(x, y).value = value;
    };
    Container2D.prototype.sort = function () {
        this._list.sort(function (a, b) { return a.y === b.y ? (a.x < b.x ? -1 : 1) : (a.y < b.y ? -1 : 1); });
    };
    return Container2D;
}());
exports.Container2D = Container2D;
