"use strict";
var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (Object.prototype.hasOwnProperty.call(b, p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        if (typeof b !== "function" && b !== null)
            throw new TypeError("Class extends value " + String(b) + " is not a constructor or null");
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
Object.defineProperty(exports, "__esModule", { value: true });
exports.Cells = void 0;
var configs_class_1 = require("../config/configs.class");
var container_2d_class_1 = require("../container-2d.class");
var cell_class_1 = require("./cell.class");
var Cells = /** @class */ (function (_super) {
    __extends(Cells, _super);
    function Cells() {
        var _this = _super.call(this, cell_class_1.Cell, function () { return undefined; }) || this;
        _this.configs = new configs_class_1.Configs(_this);
        return _this;
    }
    Object.defineProperty(Cells.prototype, "columns", {
        get: function () {
            return this.max(function (cell) { return cell.value == null ? 0 : cell.x + 1; });
        },
        enumerable: false,
        configurable: true
    });
    Object.defineProperty(Cells.prototype, "rows", {
        get: function () {
            return this.max(function (cell) { return cell.value == null ? 0 : cell.y + 1; });
        },
        enumerable: false,
        configurable: true
    });
    Object.defineProperty(Cells.prototype, "startX", {
        get: function () {
            return this.headerValues(true) ? -1 : 0;
        },
        enumerable: false,
        configurable: true
    });
    Object.defineProperty(Cells.prototype, "startY", {
        get: function () {
            return this.headerValues(false) ? -1 : 0;
        },
        enumerable: false,
        configurable: true
    });
    Cells.prototype.headerValues = function (vertical) {
        var values = [];
        var len = (vertical ? this.rows : this.columns);
        var foundCount = 0;
        for (var i = 0; i < len; i++) {
            values[i] = this.getsert((vertical ? -1 : i), (vertical ? i : -1)).value;
            values[i] != null && foundCount++;
        }
        return foundCount ? values : undefined;
    };
    Cells.prototype.headersReplace = function (vertical, newHeaders) {
        if (newHeaders != null && !Array.isArray(newHeaders)) {
            throw new Error('"newHeaders" argument must be an array');
        }
        this.remove(vertical ? (function (cell) { return cell.x === -1; }) : (function (cell) { return cell.y === -1; }));
        newHeaders = newHeaders || [];
        for (var i = 0; i < newHeaders.length; i++) {
            this.upsert((vertical ? -1 : i), (vertical ? i : -1), newHeaders[i]);
        }
    };
    Cells.prototype.upsert = function (x, y, value) {
        var options;
        if (value && typeof value === 'object') {
            options = value;
            value = value.value;
        }
        _super.prototype.upsert.call(this, x, y, value);
        if (options) {
            this.configs.upsert(x, y, options);
        }
    };
    return Cells;
}(container_2d_class_1.Container2D));
exports.Cells = Cells;
