import AsyncSearchApi from './api/async_search';
import AutoscalingApi from './api/autoscaling';
import bulkApi from './api/bulk';
import capabilitiesApi from './api/capabilities';
import CatApi from './api/cat';
import CcrApi from './api/ccr';
import clearScrollApi from './api/clear_scroll';
import closePointInTimeApi from './api/close_point_in_time';
import ClusterApi from './api/cluster';
import ConnectorApi from './api/connector';
import countApi from './api/count';
import createApi from './api/create';
import DanglingIndicesApi from './api/dangling_indices';
import deleteApi from './api/delete';
import deleteByQueryApi from './api/delete_by_query';
import deleteByQueryRethrottleApi from './api/delete_by_query_rethrottle';
import deleteScriptApi from './api/delete_script';
import EnrichApi from './api/enrich';
import EqlApi from './api/eql';
import EsqlApi from './api/esql';
import existsApi from './api/exists';
import existsSourceApi from './api/exists_source';
import explainApi from './api/explain';
import FeaturesApi from './api/features';
import fieldCapsApi from './api/field_caps';
import FleetApi from './api/fleet';
import getApi from './api/get';
import getScriptApi from './api/get_script';
import getScriptContextApi from './api/get_script_context';
import getScriptLanguagesApi from './api/get_script_languages';
import getSourceApi from './api/get_source';
import GraphApi from './api/graph';
import healthReportApi from './api/health_report';
import IlmApi from './api/ilm';
import indexApi from './api/index';
import IndicesApi from './api/indices';
import InferenceApi from './api/inference';
import infoApi from './api/info';
import IngestApi from './api/ingest';
import knnSearchApi from './api/knn_search';
import LicenseApi from './api/license';
import LogstashApi from './api/logstash';
import mgetApi from './api/mget';
import MigrationApi from './api/migration';
import MlApi from './api/ml';
import MonitoringApi from './api/monitoring';
import msearchApi from './api/msearch';
import msearchTemplateApi from './api/msearch_template';
import mtermvectorsApi from './api/mtermvectors';
import NodesApi from './api/nodes';
import openPointInTimeApi from './api/open_point_in_time';
import pingApi from './api/ping';
import ProfilingApi from './api/profiling';
import putScriptApi from './api/put_script';
import QueryRulesApi from './api/query_rules';
import rankEvalApi from './api/rank_eval';
import reindexApi from './api/reindex';
import reindexRethrottleApi from './api/reindex_rethrottle';
import renderSearchTemplateApi from './api/render_search_template';
import RollupApi from './api/rollup';
import scriptsPainlessExecuteApi from './api/scripts_painless_execute';
import scrollApi from './api/scroll';
import searchApi from './api/search';
import SearchApplicationApi from './api/search_application';
import searchMvtApi from './api/search_mvt';
import searchShardsApi from './api/search_shards';
import searchTemplateApi from './api/search_template';
import SearchableSnapshotsApi from './api/searchable_snapshots';
import SecurityApi from './api/security';
import ShutdownApi from './api/shutdown';
import SimulateApi from './api/simulate';
import SlmApi from './api/slm';
import SnapshotApi from './api/snapshot';
import SqlApi from './api/sql';
import SslApi from './api/ssl';
import StreamsApi from './api/streams';
import SynonymsApi from './api/synonyms';
import TasksApi from './api/tasks';
import termsEnumApi from './api/terms_enum';
import termvectorsApi from './api/termvectors';
import TextStructureApi from './api/text_structure';
import TransformApi from './api/transform';
import updateApi from './api/update';
import updateByQueryApi from './api/update_by_query';
import updateByQueryRethrottleApi from './api/update_by_query_rethrottle';
import WatcherApi from './api/watcher';
import XpackApi from './api/xpack';
export default interface API {
    new (): API;
    asyncSearch: AsyncSearchApi;
    autoscaling: AutoscalingApi;
    bulk: typeof bulkApi;
    capabilities: typeof capabilitiesApi;
    cat: CatApi;
    ccr: CcrApi;
    clearScroll: typeof clearScrollApi;
    closePointInTime: typeof closePointInTimeApi;
    cluster: ClusterApi;
    connector: ConnectorApi;
    count: typeof countApi;
    create: typeof createApi;
    danglingIndices: DanglingIndicesApi;
    delete: typeof deleteApi;
    deleteByQuery: typeof deleteByQueryApi;
    deleteByQueryRethrottle: typeof deleteByQueryRethrottleApi;
    deleteScript: typeof deleteScriptApi;
    enrich: EnrichApi;
    eql: EqlApi;
    esql: EsqlApi;
    exists: typeof existsApi;
    existsSource: typeof existsSourceApi;
    explain: typeof explainApi;
    features: FeaturesApi;
    fieldCaps: typeof fieldCapsApi;
    fleet: FleetApi;
    get: typeof getApi;
    getScript: typeof getScriptApi;
    getScriptContext: typeof getScriptContextApi;
    getScriptLanguages: typeof getScriptLanguagesApi;
    getSource: typeof getSourceApi;
    graph: GraphApi;
    healthReport: typeof healthReportApi;
    ilm: IlmApi;
    index: typeof indexApi;
    indices: IndicesApi;
    inference: InferenceApi;
    info: typeof infoApi;
    ingest: IngestApi;
    knnSearch: typeof knnSearchApi;
    license: LicenseApi;
    logstash: LogstashApi;
    mget: typeof mgetApi;
    migration: MigrationApi;
    ml: MlApi;
    monitoring: MonitoringApi;
    msearch: typeof msearchApi;
    msearchTemplate: typeof msearchTemplateApi;
    mtermvectors: typeof mtermvectorsApi;
    nodes: NodesApi;
    openPointInTime: typeof openPointInTimeApi;
    ping: typeof pingApi;
    profiling: ProfilingApi;
    putScript: typeof putScriptApi;
    queryRules: QueryRulesApi;
    rankEval: typeof rankEvalApi;
    reindex: typeof reindexApi;
    reindexRethrottle: typeof reindexRethrottleApi;
    renderSearchTemplate: typeof renderSearchTemplateApi;
    rollup: RollupApi;
    scriptsPainlessExecute: typeof scriptsPainlessExecuteApi;
    scroll: typeof scrollApi;
    search: typeof searchApi;
    searchApplication: SearchApplicationApi;
    searchMvt: typeof searchMvtApi;
    searchShards: typeof searchShardsApi;
    searchTemplate: typeof searchTemplateApi;
    searchableSnapshots: SearchableSnapshotsApi;
    security: SecurityApi;
    shutdown: ShutdownApi;
    simulate: SimulateApi;
    slm: SlmApi;
    snapshot: SnapshotApi;
    sql: SqlApi;
    ssl: SslApi;
    streams: StreamsApi;
    synonyms: SynonymsApi;
    tasks: TasksApi;
    termsEnum: typeof termsEnumApi;
    termvectors: typeof termvectorsApi;
    textStructure: TextStructureApi;
    transform: TransformApi;
    update: typeof updateApi;
    updateByQuery: typeof updateByQueryApi;
    updateByQueryRethrottle: typeof updateByQueryRethrottleApi;
    watcher: WatcherApi;
    xpack: XpackApi;
}
declare const kAsyncSearch: unique symbol;
declare const kAutoscaling: unique symbol;
declare const kCat: unique symbol;
declare const kCcr: unique symbol;
declare const kCluster: unique symbol;
declare const kConnector: unique symbol;
declare const kDanglingIndices: unique symbol;
declare const kEnrich: unique symbol;
declare const kEql: unique symbol;
declare const kEsql: unique symbol;
declare const kFeatures: unique symbol;
declare const kFleet: unique symbol;
declare const kGraph: unique symbol;
declare const kIlm: unique symbol;
declare const kIndices: unique symbol;
declare const kInference: unique symbol;
declare const kIngest: unique symbol;
declare const kLicense: unique symbol;
declare const kLogstash: unique symbol;
declare const kMigration: unique symbol;
declare const kMl: unique symbol;
declare const kMonitoring: unique symbol;
declare const kNodes: unique symbol;
declare const kProfiling: unique symbol;
declare const kQueryRules: unique symbol;
declare const kRollup: unique symbol;
declare const kSearchApplication: unique symbol;
declare const kSearchableSnapshots: unique symbol;
declare const kSecurity: unique symbol;
declare const kShutdown: unique symbol;
declare const kSimulate: unique symbol;
declare const kSlm: unique symbol;
declare const kSnapshot: unique symbol;
declare const kSql: unique symbol;
declare const kSsl: unique symbol;
declare const kStreams: unique symbol;
declare const kSynonyms: unique symbol;
declare const kTasks: unique symbol;
declare const kTextStructure: unique symbol;
declare const kTransform: unique symbol;
declare const kWatcher: unique symbol;
declare const kXpack: unique symbol;
export default class API {
    [kAsyncSearch]: symbol | null;
    [kAutoscaling]: symbol | null;
    [kCat]: symbol | null;
    [kCcr]: symbol | null;
    [kCluster]: symbol | null;
    [kConnector]: symbol | null;
    [kDanglingIndices]: symbol | null;
    [kEnrich]: symbol | null;
    [kEql]: symbol | null;
    [kEsql]: symbol | null;
    [kFeatures]: symbol | null;
    [kFleet]: symbol | null;
    [kGraph]: symbol | null;
    [kIlm]: symbol | null;
    [kIndices]: symbol | null;
    [kInference]: symbol | null;
    [kIngest]: symbol | null;
    [kLicense]: symbol | null;
    [kLogstash]: symbol | null;
    [kMigration]: symbol | null;
    [kMl]: symbol | null;
    [kMonitoring]: symbol | null;
    [kNodes]: symbol | null;
    [kProfiling]: symbol | null;
    [kQueryRules]: symbol | null;
    [kRollup]: symbol | null;
    [kSearchApplication]: symbol | null;
    [kSearchableSnapshots]: symbol | null;
    [kSecurity]: symbol | null;
    [kShutdown]: symbol | null;
    [kSimulate]: symbol | null;
    [kSlm]: symbol | null;
    [kSnapshot]: symbol | null;
    [kSql]: symbol | null;
    [kSsl]: symbol | null;
    [kStreams]: symbol | null;
    [kSynonyms]: symbol | null;
    [kTasks]: symbol | null;
    [kTextStructure]: symbol | null;
    [kTransform]: symbol | null;
    [kWatcher]: symbol | null;
    [kXpack]: symbol | null;
    constructor();
}
export {};
