# apg-conv-api

_**Deprecated:** Use [apg-js](https://www.npmjs.com/package/apg-js) instead. See [apg-js-examples](https://www.npmjs.com/package/apg-js-examples) for usage._

**apg-conv-api** is the API for [**apg-conv**](https://github.com/ldthomas/apg-conv).
It provides the functions for disassembling the data types as well as the encoding and decoding functions.
These can be found in the `./src/converter.js` file.

It also provides access to the low-level transformation functions which actually do the encoding and decoding.
These can be found in the `./src/transformers.js` file.

### node.js applications

In your project directory:

```
npm install apg-conv --save
```

In your application code, for example:

```
var apgConv = require("apg-conv-api");
var buf = apgConv.converter.decode("UTF8", chars);
```

### HTML applications

**apg-conv-api** has been bundled (with [webpack](https://webpack.js.org/)) for use in web page applications.
Use one of the script links:

```
<script src="./apg-conv-api.js"></script>
or
<script src="./apg-conv-api-min.js"></script>

```

This will give you access to **apg-conv-api** in your web page JavaScript through the functions and objects:

```
apgConv.convert()
apgConv.encode()
apgConv.decode()
apgConv.transfomers
apgConv.Buffer
```

Besides the high-level conversion, encoding and decoding functions, `apgConv.transformers` gives access to all of the low-level functions.

`apgConv.Buffer` is the node.js `Buffer` object for convenience.

For examples of both `node.js` and HTML usage, see these [examples](https://github.com/ldthomas/apg-js2-examples/tree/master/apg-conv-api).

## Documentation:

The documentation is in the code in [`docco`](https://jashkenas.github.io/docco/) format.
To generate the documentation, from the **apg-conv-api** package directory:

```
npm install -g docco
./docco-gen
```

View `docs/index.html` in any web browser to get started.

**Copyright:**  
 _Copyright &copy; 2017 Lowell D. Thomas, all rights reserved_

**License:**  
Released with the BSD-3-Clause license.
